# Check if profile name is valid (not empty)
$execute store success score profsave_valid at_t_interact run function at-misc:verify/data_type/is_not_null {value:"$(name)"}

# Check if profile already exists
scoreboard players set profsave_new at_t_interact 0
$execute unless data storage animated-timer:data at.profiles.content.$(name) run scoreboard players set profsave_new at_t_interact 1

# Add to list & increment profile count if it's a new profile
$execute if score profsave_valid at_t_interact matches 1 if score profsave_new at_t_interact matches 1 run data modify storage animated-timer:data at.profiles.list append value "$(name)"
execute if score profsave_valid at_t_interact matches 1 if score profsave_new at_t_interact matches 1 run scoreboard players add profiles at_s_state 1

# Clean profile if it exists
$execute if score profsave_valid at_t_interact matches 1 if score profsave_new at_t_interact matches 0 run data remove storage animated-timer:data at.profiles.content.$(name)

# Save profile
$execute if score profsave_valid at_t_interact matches 1 run function at-misc:profile/save {name:"$(name)"}
$execute if score profsave_valid at_t_interact matches 1 run tellraw @s [{"color":"#896efb","text":"[AT] "},{"color":"#c4a2ff","text":"Saved current configuration at profile $(name)"}]

# Print error on invalid profile name
execute if score profsave_valid at_t_interact matches 0 run tellraw @s [{"color":"#cb2222","text":"[AT] "},{"color":"#ff5555","text":"Profile name cannot be empty"}]
